// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f
#define QUALITY 8

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

vec3 grayscale (vec3 color) {
  return (vec3)(0.2126f*color.z + 0.7152f*color.y + 0.0722f*color.x);
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

float rand(vec2 co){
	float temp; 
	return fract(sin(dot(co.xy ,(vec2)(12.9898f,78.233f))) * 43758.5453f,&temp);
}

float myMod(float x ,float y)
{
	return x-y * floor (x/y);
}

__constant float size = 0.6f;
 
__constant float GOLDEN_ANGLE = 2.399963229728653f; // PI * (3.0 - sqrt(5.0))
 
vec4 blur(int fromorto, vec2 c, float radius, image2d_t input1, image2d_t input2,__global FilterParam* param) {
  vec4 sum = (vec4)(0.0f);
  float q = (float)(QUALITY);
  // Using a "spiral" to propagate points.
  for (int i=0; i<QUALITY; ++i) {
    float fi = (float)(i);
    float a = fi * GOLDEN_ANGLE;
    float r = sqrt(fi / q) * radius;
    vec2 p = c + r * (vec2)(cos(a), sin(a));
	if(0 == fromorto)
	{
		sum += INPUT(input1, param, p);
	}
	
	if(1 == fromorto)
	{
		sum += INPUT(input2, param, p);
	}
  }
  return sum / q;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float inv = 1.f-progress;
	float4 gl_FragColor = inv*blur(0, p, progress*size, input1, input2, param) + progress*blur(1, p, inv*size, input1, input2, param);
		
	write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}